   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.30  10/19/06            */
   /*                                                     */
   /*             DEFRULE COMMANDS HEADER FILE            */
   /*******************************************************/

/*************************************************************/
/* Purpose: Provides the matches command. Also provides the  */
/*   the developer commands show-joins and rule-complexity.  */
/*   Also provides the initialization routine which          */
/*   registers rule commands found in other modules.         */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*      Brian L. Donnell                                     */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.24: Renamed BOOLEAN macro type to intBool.         */
/*                                                           */
/*      6.30: Added support for hashed alpha memories.       */
/*                                                           */
/*            Added matches-count function.                  */
/*                                                           */
/*            Added get-join-hashing and set-join-hashing    */
/*            functions.                                     */
/*                                                           */
/*************************************************************/

#ifndef _H_rulecom
#define _H_rulecom

#ifndef _H_evaluatn
#include "evaluatn.h"
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _RULECOM_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

#if ENVIRONMENT_API_ONLY
#define Matches(theEnv,a) EnvMatches(theEnv,a)
#define MatchesCount(theEnv,a) EnvMatchesCount(theEnv,a)
#define GetJoinHashing(theEnv) EnvGetJoinHashing(theEnv)
#define SetJoinHashing(theEnv,a) EnvSetJoinHashing(theEnv,a)
#else
#define Matches(a) EnvMatches(GetCurrentEnvironment(),a)
#define MatchesCount(a) EnvMatchesCount(GetCurrentEnvironment(),a)
#define GetJoinHashing() EnvGetJoinHashing(GetCurrentEnvironment())
#define SetJoinHashing(a) EnvSetJoinHashing(GetCurrentEnvironment(),a)
#endif

   LOCALE intBool                        EnvGetJoinHashing(void *);
   LOCALE intBool                        EnvSetJoinHashing(void *,intBool);
   LOCALE int                            GetJoinHashingCommand(void *);
   LOCALE int                            SetJoinHashingCommand(void *);
   LOCALE intBool                        EnvMatches(void *,void *);
   LOCALE intBool                        EnvMatchesCount(void *,void *);
   LOCALE void                           DefruleCommands(void *);
   LOCALE void                           MatchesCommand(void *);
   LOCALE void                           MatchesCountCommand(void *);
#if DEVELOPER
   LOCALE void                           ShowJoinsCommand(void *);
   LOCALE long                           RuleComplexityCommand(void *);
   LOCALE void                           ShowAlphaHashTable(void *);
#endif

#endif


